/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.potions;

import com.megacrit.cardcrawl.actions.common.HealAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;

public class HealthPotion
extends AbstractPotion {
    public static final String POTION_ID = "Health Potion";
    private static final PotionStrings potionStrings = CardCrawlGame.languagePack.getPotionString("Health Potion");
    public static final String NAME = HealthPotion.potionStrings.NAME;
    public static final String[] DESCRIPTIONS = HealthPotion.potionStrings.DESCRIPTIONS;

    public HealthPotion() {
        super(NAME, POTION_ID, AbstractPotion.PotionSize.T, AbstractPotion.PotionColor.GREEN);
        this.potency = 9;
        this.description = DESCRIPTIONS[0] + this.potency + DESCRIPTIONS[1];
        this.isThrown = false;
        this.tips.add(new PowerTip(this.name, this.description));
    }

    @Override
    public void use(AbstractCreature target) {
        AbstractDungeon.actionManager.addToBottom(new HealAction(target, AbstractDungeon.player, this.potency));
    }

    @Override
    public AbstractPotion makeCopy() {
        return new HealthPotion();
    }
}

